<?php

$edgt_custom_sidebars = hudson_edge_get_custom_sidebars();

$edgt_blog_categories = array();
$categories           = get_categories();
foreach ( $categories as $category ) {
	$edgt_blog_categories[ $category->term_id ] = $category->name;
}
$hudson_edge_icon_collections = hudson_edge_return_icon_collections();

//General

$edgtGeneral = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "General", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_general",
	$edgtGeneral
);

$edgt_page_background_color = new HudsonEdgeMetaField(
	"color",
	"edgt_page_background_color",
	"",
	esc_html__( "Page Background Color", 'hudson' ),
	esc_html__( "Choose the page background (body) color", 'hudson' )
);
$edgtGeneral->addChild(
	"edgt_page_background_color",
	$edgt_page_background_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Content Style", 'hudson' ),
	esc_html__( "Define styles for Content area", 'hudson' )
);
$edgtGeneral->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_enable_content_top_margin = new HudsonEdgeMetaField(
	"yesnosimple",
	"edgt_enable_content_top_margin",
	"no",
	esc_html__( "Always put content below header", 'hudson' ),
	esc_html__( "Enabling this option always will put content below header ", 'hudson' )
);
$row1->addChild(
	"edgt_enable_content_top_margin",
	$edgt_enable_content_top_margin
);

$edgt_content_top_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_content-top-padding",
	"",
	esc_html__( "Content Top Padding (px)", 'hudson' ),
	esc_html__( "This option control content top padding.", 'hudson' )
);
$row1->addChild(
	"edgt_content-top-padding",
	$edgt_content_top_padding
);

$edgt_content_top_padding_mobile = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_content-top-padding-mobile",
	"",
	esc_html__( "Set this top padding for mobile header", 'hudson' ),
	"",
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$row1->addChild(
	"edgt_content-top-padding-mobile",
	$edgt_content_top_padding_mobile
);

$edgt_show_animation = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_show-animation",
	"",
	esc_html__( "Page Transition", 'hudson' ),
	esc_html__( 'Choose a type of transition between loading pages.', 'hudson' ),
	array(
		"no_animation" => esc_html__( "No Animation", 'hudson' ),
		"updown" => esc_html__( "Up / Down", 'hudson' ),
		"fade" => esc_html__( "Fade", 'hudson' ),
		"updown_fade" => esc_html__( "Up/Down (In) / Fade (Out)", 'hudson' ),
		"leftright" => esc_html__( "Left / Right", 'hudson' )
	),
	array(),
	"enable_grid_elements",
	array( "yes" )
);
$edgtGeneral->addChild(
	"edgt_show-animation",
	$edgt_show_animation
);

$page_transitions_notice = new HudsonEdgeNotice(
	esc_html__( "Page Transition", 'hudson' ),
	esc_html__( 'Choose a a type of transition between loading pages. In order for animation to work properly, you must choose "Post name" in permalinks settings', 'hudson' ),
	esc_html__( "AJAX Page transitions are disabled due to VC Grid Elements", 'hudson' ),
	"enable_grid_elements",
	"no"
);
$edgtGeneral->addChild(
	"page_transitions_notice",
	$page_transitions_notice
);

$edgt_revolution_slider = new HudsonEdgeMetaField(
	"text",
	"edgt_revolution-slider",
	"",
	esc_html__( "Layer Slider or Edge Slider Shortcode", 'hudson' ),
	esc_html__( "Copy and paste your shortcode located in Edge Slider -> Slider", 'hudson' )
);
$edgtGeneral->addChild(
	"edgt_revolution-slider",
	$edgt_revolution_slider
);

$edgt_enable_page_comments = new HudsonEdgeMetaField(
	"yesno",
	"edgt_enable-page-comments",
	"no",
	esc_html__( "Show Comments", 'hudson' ),
	esc_html__( "Enabling this option will show comments on your page ", 'hudson' )
);
$edgtGeneral->addChild(
	"edgt_enable-page-comments",
	$edgt_enable_page_comments
);

// Side Menu Area

$edgtLeftMenuArea = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Side Menu Area", 'hudson' ),
	"vertical_area",
	array( "no" )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_left_menu",
	$edgtLeftMenuArea
);

$edgt_page_vertical_area_transparency = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_vertical_area_transparency",
	"",
	esc_html__( "Enable transparent side menu area", 'hudson' ),
	esc_html__( "Enabling this option will make Side Menu background transparent ", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtLeftMenuArea->addChild(
	"edgt_page_vertical_area_transparency",
	$edgt_page_vertical_area_transparency
);

$edgt_page_vertical_area_background = new HudsonEdgeMetaField(
	"color",
	"edgt_page_vertical_area_background",
	"",
	esc_html__( "Side Menu Area Background Color", 'hudson' ),
	esc_html__( "Choose a color for Side Menu background", 'hudson' )
);
$edgtLeftMenuArea->addChild(
	"edgt_page_vertical_area_background",
	$edgt_page_vertical_area_background
);

$edgt_page_vertical_area_background_opacity = new HudsonEdgeMetaField(
	"text",
	"edgt_page_vertical_area_background_opacity",
	"",
	esc_html__( "Side Menu Area Background Opacity", 'hudson' ),
	esc_html__( "Choose a opacity for the Side Menu Area Background (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtLeftMenuArea->addChild(
	"edgt_page_vertical_area_background_opacity",
	$edgt_page_vertical_area_background_opacity
);

$edgt_page_vertical_area_transparency_over_slider = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_vertical_area_transparency_over_slider",
	"",
	esc_html__( "Transparency Setting Takes Effect Only on Edge Slider", 'hudson' ),
	esc_html__( "Enabling this option will ensure that the transparency set in the 'Side Menu Area Background Opacity' takes effect only when the side menu area is over the Edge Slider", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtLeftMenuArea->addChild(
	"edgt_page_vertical_area_transparency_over_slider",
	$edgt_page_vertical_area_transparency_over_slider
);

$edgt_page_vertical_area_background_image = new HudsonEdgeMetaField(
	"image",
	"edgt_page_vertical_area_background_image",
	"",
	esc_html__( "Side Menu Area Background Image", 'hudson' ),
	esc_html__( "Choose an image for Side Menu background", 'hudson' )
);
$edgtLeftMenuArea->addChild(
	"edgt_page_vertical_area_background_image",
	$edgt_page_vertical_area_background_image
);

$edgt_page_disable_vertical_area_background_image = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_disable_vertical_area_background_image",
	"",
	esc_html__( "Disable Side Menu Area Background Image", 'hudson' ),
	esc_html__( "Enabling this option will hide background image in Side Menu", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtLeftMenuArea->addChild(
	"edgt_page_disable_vertical_area_background_image",
	$edgt_page_disable_vertical_area_background_image
);

// Header

$edgtHeader = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Header", 'hudson' ),
	"vertical_area",
	array( "yes" )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_header",
	$edgtHeader
);

$edgt_header_style = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_header-style",
	"",
	esc_html__( "Header Skin", 'hudson' ),
	esc_html__( "Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style", 'hudson' ),
	array(
		"light" => esc_html__( "Light", 'hudson' ),
		"dark" => esc_html__( "Dark", 'hudson' )
	)
);
$edgtHeader->addChild(
	"edgt_header-style",
	$edgt_header_style
);

$edgt_header_style_on_scroll = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_header-style-on-scroll",
	"",
	esc_html__( "Enable Header Style on Scroll", 'hudson' ),
	esc_html__( "Enabling this option, header will change style on scroll (depending on row settings) to make header elements (logo, main menu, side menu button) in that style", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtHeader->addChild(
	"edgt_header-style-on-scroll",
	$edgt_header_style_on_scroll
);

$edgt_header_color_per_page = new HudsonEdgeMetaField(
	"color",
	"edgt_header_color_per_page",
	"",
	esc_html__( "Initial Header Background Color", 'hudson' ),
	esc_html__( "Choose a background color for header area", 'hudson' )
);
$edgtHeader->addChild(
	"edgt_header_color_per_page",
	$edgt_header_color_per_page
);

$edgt_header_color_transparency_per_page = new HudsonEdgeMetaField(
	"text",
	"edgt_header_color_transparency_per_page",
	"",
	esc_html__( "Initial Header Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtHeader->addChild(
	"edgt_header_color_transparency_per_page",
	$edgt_header_color_transparency_per_page
);

$edgt_header_bottom_border_color = new HudsonEdgeMetaField(
	"color",
	"edgt_header_bottom_border_color",
	"",
	esc_html__( "Initial Header Bottom Border Color", 'hudson' ),
	esc_html__( "Choose a bottom border color for header area", 'hudson' )
);
$edgtHeader->addChild(
	"edgt_header_bottom_border_color",
	$edgt_header_bottom_border_color
);

$edgt_page_scroll_amount_for_sticky = new HudsonEdgeMetaField(
	"text",
	"edgt_page_scroll_amount_for_sticky",
	"",
	esc_html__( "Scroll amount for sticky header appearance (px)", 'hudson' ),
	esc_html__( "Define scroll amount for sticky header appearance", 'hudson' ),
	array(),
	array( "col_width" => 3 ),
	"header_bottom_appearance",
	array( "regular", "fixed", "fixed_hiding" )
);
$edgtHeader->addChild(
	"edgt_page_scroll_amount_for_sticky",
	$edgt_page_scroll_amount_for_sticky
);

$edgt_page_hide_initial_sticky = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_hide_initial_sticky",
	"",
	esc_html__( "Hide Sticky Header Initially", 'hudson' ),
	esc_html__( "Enabling this option will initially hide the header, and it will only be displayed when the user scrolls down the page", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtHeader->addChild(
	"edgt_page_hide_initial_sticky",
	$edgt_page_hide_initial_sticky
);
// Title

$edgtTitle = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Title", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_title",
	$edgtTitle
);

$edgt_show_page_title = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_show-page-title",
	"",
	esc_html__( "Show Title Area", 'hudson' ),
	esc_html__( "Disabling this option will turn off page title area", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"no" => "#edgtf_edgt_page_title_area_container, #edgtf-meta-box-page_title_animations"
		),
		"show"       => array(
			""    => "#edgtf_edgt_page_title_area_container, #edgtf-meta-box-page_title_animations",
			"yes" => "#edgtf_edgt_page_title_area_container, #edgtf-meta-box-page_title_animations"
		)
	)
);
$edgtTitle->addChild(
	"edgt_show-page-title",
	$edgt_show_page_title
);

$edgt_page_title_area_container = new HudsonEdgeContainer(
	"edgt_page_title_area_container",
	"edgt_show-page-title",
	"no"
);
$edgtTitle->addChild(
	"edgt_page_title_area_container",
	$edgt_page_title_area_container
);

$edgt_page_title_type = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_title_type",
	"",
	esc_html__( "Title Type", 'hudson' ),
	esc_html__( "Choose title type for this page.", 'hudson' ),
	array(
		"standard_title" => esc_html__( "Standard", 'hudson' ),
		"breadcrumbs_title" => esc_html__( "Breadcrumbs", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "breadcrumbs_title" => "#edgtf_edgt_title_standard_container" ),
		"show"       => array(
			"standard_title" => "#edgtf_edgt_title_standard_container",
			""               => "#edgtf_edgt_title_standard_container"
		)
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_page_title_type",
	$edgt_page_title_type
);

$edgt_animate_page_title = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_animate_page_title",
	"",
	esc_html__( "Animations", 'hudson' ),
	esc_html__( "Choose an animation for Title Area", 'hudson' ),
	array(
		"no" => esc_html__( "No animation", 'hudson' ),
		"text_right_left" => esc_html__( "Text right to left", 'hudson' ),
		"area_top_bottom" => esc_html__( "Title area top to bottom", 'hudson' )
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_animate_page_title",
	$edgt_animate_page_title
);

$edgt_page_page_title_vertical_aligment = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_page_title_vertical_aligment",
	"",
	esc_html__( "Vertical Alignment", 'hudson' ),
	esc_html__( "Specify Title vertical alignment", 'hudson' ),
	array(
		"header_bottom" => esc_html__( "From Bottom of Header", 'hudson' ),
		"window_top" => esc_html__( "From Window Top", 'hudson' )
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_page_page_title_vertical_aligment",
	$edgt_page_page_title_vertical_aligment
);

$edgt_show_page_title_text = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_show_page_title_text",
	"",
	esc_html__( "Show Title Text", 'hudson' ),
	esc_html__( "Disabling this option will turn off page title text", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"no" => "#edgtf_edgt_title_text_container, #edgtf_animation_page_page_title_container"
		),
		"show"       => array(
			""    => "#edgtf_edgt_title_text_container, #edgtf_animation_page_page_title_container",
			"yes" => "#edgtf_edgt_title_text_container, #edgtf_animation_page_page_title_container"
		)
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_show_page_title_text",
	$edgt_show_page_title_text
);

$edgt_title_text_container = new HudsonEdgeContainer(
	"edgt_title_text_container",
	"edgt_show_page_title_text",
	"no"
);
$edgt_page_title_area_container->addChild(
	"edgt_title_text_container",
	$edgt_title_text_container
);

$edgt_page_title_position = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_title_position",
	"",
	esc_html__( "Title Text Alignment", 'hudson' ),
	esc_html__( "Specify Title text alignment", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$edgt_title_text_container->addChild(
	"edgt_page_title_position",
	$edgt_page_title_position
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title Text Style", 'hudson' ),
	esc_html__( "Define styles for text in Title Area", 'hudson' )
);
$edgt_title_text_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_page_title_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_page-title-color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "ThisIsDescription", 'hudson' )
);
$row1->addChild(
	"edgt_page-title-color",
	$edgt_page_title_color
);

$edgt_title_text_shadow = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_title_text_shadow",
	"",
	esc_html__( "Text Shadow", 'hudson' ),
	esc_html__( "ThisIsDescription", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "yes", 'hudson' )
	)
);
$row1->addChild(
	"edgt_title_text_shadow",
	$edgt_title_text_shadow
);

$edgt_page_title_font_size = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_page_title_font_size",
	"",
	esc_html__( "Text Size", 'hudson' ),
	esc_html__( "ThisIsDescription", 'hudson' ),
	array(
		"small" => esc_html__( "Small", 'hudson' ),
		"medium" => esc_html__( "Medium", 'hudson' ),
		"large" => esc_html__( "Large", 'hudson' )
	)
);
$row1->addChild(
	"edgt_page_title_font_size",
	$edgt_page_title_font_size
);

$edgt_title_standard_container = new HudsonEdgeContainer(
	"edgt_title_standard_container",
	"edgt_page_title_type",
	"breadcrumbs_title"
);
$edgt_page_title_area_container->addChild(
	"edgt_title_standard_container",
	$edgt_title_standard_container
);

$edgt_title_like_separator = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_title_like_separator",
	"",
	esc_html__( "Show Separator Around Title Text", 'hudson' ),
	esc_html__( "Choose if you want title to look like separator with text", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"no" => "#edgtf_edgt_title_like_separator_container",
			""   => "#edgtf_edgt_title_like_separator_container"
		),
		"show"       => array(
			"yes" => "#edgtf_edgt_title_like_separator_container"
		)
	)
);
$edgt_title_standard_container->addChild(
	"edgt_title_like_separator",
	$edgt_title_like_separator
);

$edgt_title_like_separator_container = new HudsonEdgeContainer(
	"edgt_title_like_separator_container",
	"edgt_title_like_separator",
	"",
	array( '', 'no' )
);
$edgt_title_standard_container->addChild(
	"edgt_title_like_separator_container",
	$edgt_title_like_separator_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Line Styles", 'hudson' ),
	esc_html__( "Choose style for separator line", 'hudson' )
);
$edgt_title_like_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_title_like_separator_line_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_like_separator_line_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_like_separator_line_color",
	$edgt_title_like_separator_line_color
);

$edgt_title_like_separator_line_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_like_separator_line_width",
	"",
	esc_html__( "Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_like_separator_line_width",
	$edgt_title_like_separator_line_width
);

$edgt_title_like_separator_line_thickness = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_like_separator_line_thickness",
	"",
	esc_html__( "Thickness", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_like_separator_line_thickness",
	$edgt_title_like_separator_line_thickness
);

$edgt_title_like_separator_line_style = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_title_like_separator_line_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$row1->addChild(
	"edgt_title_like_separator_line_style",
	$edgt_title_like_separator_line_style
);

$edgt_title_like_separator_margins = new HudsonEdgeMetaField(
	"text",
	"edgt_title_like_separator_margins",
	"",
	esc_html__( "Margins for Title", 'hudson' ),
	esc_html__( "Define left/right margins for title from separator", 'hudson' )
);
$edgt_title_like_separator_container->addChild(
	"edgt_title_like_separator_margins",
	$edgt_title_like_separator_margins
);

$edgt_title_like_separator_line_dots = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_title_like_separator_line_dots",
	"",
	esc_html__( "Dots on The End of Lines", 'hudson' ),
	esc_html__( "Enabling this option will give lines a dot next to title", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "no" => "#edgtf_edgt_title_like_separator_dots_container" ),
		"show"       => array(
			"yes" => "#edgtf_edgt_title_like_separator_dots_container",
			""    => "#edgtf_edgt_title_like_separator_dots_container"
		)
	)
);
$edgt_title_like_separator_container->addChild(
	"edgt_title_like_separator_line_dots",
	$edgt_title_like_separator_line_dots
);

$edgt_title_like_separator_dots_container = new HudsonEdgeContainer(
	"edgt_title_like_separator_dots_container",
	"edgt_title_like_separator_line_dots",
	"no"
);
$edgt_title_like_separator_container->addChild(
	"edgt_title_like_separator_dots_container",
	$edgt_title_like_separator_dots_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Dots Style", 'hudson' ),
	esc_html__( "Choose style for dots", 'hudson' )
);
$edgt_title_like_separator_dots_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_title_like_separator_dots_size = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_like_separator_dots_size",
	"",
	esc_html__( "Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_like_separator_dots_size",
	$edgt_title_like_separator_dots_size
);

$edgt_title_like_separator_dots_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_like_separator_dots_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_like_separator_dots_color",
	$edgt_title_like_separator_dots_color
);

$edgt_subtitle_like_separator = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_subtitle_like_separator",
	"",
	esc_html__( "Show Separator Around Subtitle Text", 'hudson' ),
	esc_html__( "Choose if you want title to look like separator with text", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""   => "#edgtf_edgt_subtitle_like_separator_container",
			"no" => "#edgtf_edgt_subtitle_like_separator_container"
		),
		"show"       => array(
			"yes" => "#edgtf_edgt_subtitle_like_separator_container"
		)
	)
);
$edgt_title_standard_container->addChild(
	"edgt_subtitle_like_separator",
	$edgt_subtitle_like_separator
);

$edgt_subtitle_like_separator_container = new HudsonEdgeContainer(
	"edgt_subtitle_like_separator_container",
	"edgt_subtitle_like_separator",
	"",
	array( '', 'no' )
);
$edgt_title_standard_container->addChild(
	"edgt_subtitle_like_separator_container",
	$edgt_subtitle_like_separator_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Line Styles", 'hudson' ),
	esc_html__( "Choose style for separator line", 'hudson' )
);
$edgt_subtitle_like_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_subtitle_like_separator_line_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_subtitle_like_separator_line_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_like_separator_line_color",
	$edgt_subtitle_like_separator_line_color
);

$edgt_subtitle_like_separator_line_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_like_separator_line_width",
	"",
	esc_html__( "Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_like_separator_line_width",
	$edgt_subtitle_like_separator_line_width
);

$edgt_subtitle_like_separator_line_thickness = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_like_separator_line_thickness",
	"",
	esc_html__( "Thickness", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_like_separator_line_thickness",
	$edgt_subtitle_like_separator_line_thickness
);

$edgt_subtitle_like_separator_line_style = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_subtitle_like_separator_line_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$row1->addChild(
	"edgt_subtitle_like_separator_line_style",
	$edgt_subtitle_like_separator_line_style
);

$edgt_subtitle_like_separator_margins = new HudsonEdgeMetaField(
	"text",
	"edgt_subtitle_like_separator_margins",
	"",
	esc_html__( "Margins for Subtitle", 'hudson' ),
	esc_html__( "Define left/right margins for subtitle from separator", 'hudson' )
);
$edgt_subtitle_like_separator_container->addChild(
	"edgt_subtitle_like_separator_margins",
	$edgt_subtitle_like_separator_margins
);

$edgt_subtitle_like_separator_animation = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_subtitle_like_separator_animation",
	"",
	esc_html__( "Animate Width", 'hudson' ),
	esc_html__( "Enabling this option will animate width of the separator", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	)
);
$edgt_subtitle_like_separator_container->addChild(
	"edgt_subtitle_like_separator_margins",
	$edgt_subtitle_like_separator_animation
);

$edgt_page_title_background_color = new HudsonEdgeMetaField(
	"color",
	"edgt_page-title-background-color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose background color for Title Area", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_page-title-background-color",
	$edgt_page_title_background_color
);

$edgt_show_page_title_image = new HudsonEdgeMetaField(
	"yesno",
	"edgt_show-page-title-image",
	"no",
	esc_html__( "Don't Show Background Image", 'hudson' ),
	esc_html__( "Enable this option to hide background image in Title Area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_edgt_background_image_container",
		"dependence_show_on_yes" => "#edgtf_edgt_title-height"
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_show-page-title-image",
	$edgt_show_page_title_image
);

$edgt_background_image_container = new HudsonEdgeContainer(
	"edgt_background_image_container",
	"edgt_show-page-title-image",
	"yes"
);
$edgt_page_title_area_container->addChild(
	"edgt_background_image_container",
	$edgt_background_image_container
);

$edgt_title_image = new HudsonEdgeMetaField(
	"image",
	"edgt_title-image",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose a background image for Title Area", 'hudson' )
);
$edgt_background_image_container->addChild(
	"edgt_title-image",
	$edgt_title_image
);

$edgt_title_overlay_image = new HudsonEdgeMetaField(
	"image",
	"edgt_title-overlay-image",
	"",
	esc_html__( "Pattern Overlay Image", 'hudson' ),
	esc_html__( "Choose an image to be used as pattern over Title Area", 'hudson' )
);
$edgt_background_image_container->addChild(
	"edgt_title-overlay-image",
	$edgt_title_overlay_image
);

$edgt_responsive_title_image = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_responsive-title-image",
	"",
	esc_html__( "Responsive Background Image", 'hudson' ),
	esc_html__( "Do you want to make Title background image responsive?", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"yes" => "#edgtf_edgt_responsive_title_image_container, #edgtf_edgt_title-height"
		),
		"show"       => array(
			""   => "#edgtf_edgt_responsive_title_image_container, #edgtf_edgt_title-height",
			"no" => "#edgtf_edgt_responsive_title_image_container, #edgtf_edgt_title-height"
		)
	)
);
$edgt_background_image_container->addChild(
	"edgt_responsive-title-image",
	$edgt_responsive_title_image
);

$edgt_responsive_title_image_container = new HudsonEdgeContainer(
	"edgt_responsive_title_image_container",
	"edgt_responsive-title-image",
	"yes"
);
$edgt_background_image_container->addChild(
	"edgt_responsive_title_image_container",
	$edgt_responsive_title_image_container
);

$edgt_fixed_title_image = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_fixed-title-image",
	"",
	esc_html__( "Parallax Background Image", 'hudson' ),
	esc_html__( "Do you want background image to have parallax effect?", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' ),
		"yes_zoom" => esc_html__( "Yes, with zoom out", 'hudson' )
	)
);
$edgt_responsive_title_image_container->addChild(
	"edgt_fixed-title-image",
	$edgt_fixed_title_image
);

$edgt_title_height = new HudsonEdgeMetaField(
	"text",
	"edgt_title-height",
	"",
	esc_html__( "Title Height (px)", 'hudson' ),
	esc_html__( "Set a height for Title Area in pixels", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgt_page_title_area_container->addChild(
	"edgt_title-height",
	$edgt_title_height
);

$edgt_border_top_title_area = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_border_top_title_area",
	"",
	esc_html__( "Top Border", 'hudson' ),
	esc_html__( "Choose weather to show border top on title area", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "no" => "#edgtf_edgt_title_border_top_container" ),
		"show"       => array( "yes" => "#edgtf_edgt_title_border_top_container" )
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_border_top_title_area",
	$edgt_border_top_title_area
);

$edgt_title_border_top_container = new HudsonEdgeContainer(
	"edgt_title_border_top_container",
	"edgt_border_top_title_area",
	"no"
);
$edgt_page_title_area_container->addChild(
	"edgt_title_border_top_container",
	$edgt_title_border_top_container
);

$edgt_border_top_title_area_in_grid = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_border_top_title_area_in_grid",
	"",
	esc_html__( "Enable Border in Grid", 'hudson' ),
	esc_html__( "Enable this option to show border in grid", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	)
);
$edgt_title_border_top_container->addChild(
	"edgt_border_top_title_area_in_grid",
	$edgt_border_top_title_area_in_grid
);

$edgt_border_top_title_area_color = new HudsonEdgeMetaField(
	"color",
	"edgt_border_top_title_area_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border top color", 'hudson' )
);
$edgt_title_border_top_container->addChild(
	"edgt_border_top_title_area_color",
	$edgt_border_top_title_area_color
);

$edgt_border_top_title_area_width = new HudsonEdgeMetaField(
	"text",
	"edgt_border_top_title_area_width",
	"",
	esc_html__( "Border Width", 'hudson' ),
	esc_html__( "Choose border top width", 'hudson' )
);
$edgt_title_border_top_container->addChild(
	"edgt_border_top_title_area_width",
	$edgt_border_top_title_area_width
);

$edgt_border_bottom_title_area = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_border_bottom_title_area",
	"",
	esc_html__( "Bottom Border", 'hudson' ),
	esc_html__( "Choose weather to show border bottom on title area", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array( "no" => "#edgtf_edgt_title_border_bottom_container" ),
		"show"       => array( "yes" => "#edgtf_edgt_title_border_bottom_container" )
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_border_bottom_title_area",
	$edgt_border_bottom_title_area
);

$edgt_title_border_bottom_container = new HudsonEdgeContainer(
	"edgt_title_border_bottom_container",
	"edgt_border_bottom_title_area",
	"no"
);
$edgt_page_title_area_container->addChild(
	"edgt_title_border_bottom_container",
	$edgt_title_border_bottom_container
);

$edgt_border_bottom_title_area_in_grid = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_border_bottom_title_area_in_grid",
	"",
	esc_html__( "Enable Border in Grid", 'hudson' ),
	esc_html__( "Enable this option to show border in grid", 'hudson' ),
	array(
		"yes" => esc_html__( "Yes", 'hudson' ),
		"no" => esc_html__( "No", 'hudson' )
	)
);
$edgt_title_border_bottom_container->addChild(
	"edgt_border_bottom_title_area_in_grid",
	$edgt_border_bottom_title_area_in_grid
);

$edgt_border_bottom_title_area_color = new HudsonEdgeMetaField(
	"color",
	"edgt_border_bottom_title_area_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border bottom color", 'hudson' )
);
$edgt_title_border_bottom_container->addChild(
	"edgt_border_bottom_title_area_color",
	$edgt_border_bottom_title_area_color
);

$edgt_border_bottom_title_area_width = new HudsonEdgeMetaField(
	"text",
	"edgt_border_bottom_title_area_width",
	"",
	esc_html__( "Border Width", 'hudson' ),
	esc_html__( "Choose border bottom width", 'hudson' )
);
$edgt_title_border_bottom_container->addChild(
	"edgt_border_bottom_title_area_width",
	$edgt_border_bottom_title_area_width
);

//Separator

$edgt_title_separator = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_title_separator",
	"",
	esc_html__( "Show Title Separator", 'hudson' ),
	esc_html__( "Enabling this option will display a separator underneath Title", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""   => "#edgtf_edgt_title_separator_container",
			"no" => "#edgtf_edgt_title_separator_container"
		),
		"show"       => array(
			"yes" => "#edgtf_edgt_title_separator_container"
		)
	)
);
$edgt_title_standard_container->addChild(
	"edgt_title_separator",
	$edgt_title_separator
);

$edgt_title_separator_container = new HudsonEdgeContainer(
	"edgt_title_separator_container",
	"edgt_title_separator",
	"",
	array( '', 'no' )
);
$edgt_title_standard_container->addChild(
	"edgt_title_separator_container",
	$edgt_title_separator_container
);

$edgt_title_separator_format = new HudsonEdgeMetaField(
	"select",
	"edgt_title_separator_format",
	"",
	esc_html__( "Format", 'hudson' ),
	esc_html__( "Choose a format (type) of separator", 'hudson' ),
	array(
		""                 => "",
		"normal" => esc_html__( "Normal", 'hudson' ),
		"with_icon" => esc_html__( "With Icon", 'hudson' ),
		"with_custom_icon" => esc_html__( "With Custom Icon", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""                 => "#edgtf_edgt_separator_with_icon_container, #edgtf_edgt_separator_with_custom_icon_container",
			"normal"           => "#edgtf_edgt_separator_with_icon_container, #edgtf_edgt_separator_with_custom_icon_container",
			"with_custom_icon" => "#edgtf_edgt_separator_with_icon_container",
			"with_icon"        => "#edgtf_edgt_separator_with_custom_icon_container"
		),
		"show"       => array(
			"with_icon"        => "#edgtf_edgt_separator_with_icon_container",
			"with_custom_icon" => "#edgtf_edgt_separator_with_custom_icon_container"
		)
	)
);

$edgt_title_separator_container->addChild(
	"edgt_title_separator_format",
	$edgt_title_separator_format
);

$edgt_separator_with_icon_container = new HudsonEdgeContainer(
	"edgt_separator_with_icon_container",
	"edgt_title_separator_format",
	"normal",
	array( "normal", "with_custom_icon", "" )
);
$edgt_title_separator_container->addChild(
	"edgt_separator_with_icon_container",
	$edgt_separator_with_icon_container
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$separator_icon_pack_hide_array     = array();
$separator_icon_pack_show_array     = array();
$separator_icon_pack_hide_array[""] = "";

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$separator_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$separator_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$separator_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_edgt_separator_icon_' . $dep_collection_object->param . '_container';
		$separator_icon_pack_hide_array[""]                    .= '#edgtf_edgt_separator_icon_' . $dep_collection_object->param . '_container,';
		
		//for all collections param generate hide string
		foreach ( $separator_icon_collections_params as $separator_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $separator_icon_collections_param !== $dep_collection_object->param ) {
				$separator_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_edgt_separator_icon_' . $separator_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$separator_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$separator_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
		
	}
	
	$separator_icon_pack_hide_array[""] = rtrim(
		$separator_icon_pack_hide_array[""],
		','
	);
	
}

$edgt_separator_icon_pack = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_separator_icon_pack",
	"",
	esc_html__( "Separator Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for separator", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $separator_icon_pack_hide_array,
		"show"       => $separator_icon_pack_show_array
	)
);

$edgt_separator_with_icon_container->addChild(
	"edgt_separator_icon_pack",
	$edgt_separator_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$separator_icon_hide_values    = $icon_collections_keys;
		$separator_icon_hide_values[]  = "";
		$edgt_separator_icon_container = new HudsonEdgeContainer(
			"edgt_separator_icon_" . $collection_object->param . "_container",
			"edgt_separator_icon_pack",
			"",
			$separator_icon_hide_values
		);
		$edgt_separator_icon           = new HudsonEdgeMetaField(
			"select",
			"edgt_separator_icon_" . $collection_object->param,
			"",
			esc_html__( "Separator Icon", 'hudson' ),
			esc_html__( "Choose Separator Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$edgt_separator_icon_container->addChild(
			"edgt_separator_icon_" . $collection_object->param,
			$edgt_separator_icon
		);
		
		$edgt_separator_with_icon_container->addChild(
			"edgt_separator_icon_" . $collection_object->param . "_container",
			$edgt_separator_icon_container
		);
	}
	
}

$group1 = new HudsonEdgeGroup(
	esc_html__( "Icon Style", 'hudson' ),
	esc_html__( "Choose icon style", 'hudson' )
);
$edgt_separator_with_icon_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_title_separator_icon_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color of icon for Title separator", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_color",
	$edgt_title_separator_icon_color
);

$edgt_title_separator_icon_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color of icon for Title separator", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_hover_color",
	$edgt_title_separator_icon_hover_color
);

$edgt_title_separator_icon_custom_size = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_icon_custom_size",
	"",
	esc_html__( "Icon Size", 'hudson' ),
	esc_html__( "Choose size of icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_custom_size",
	$edgt_title_separator_icon_custom_size
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Icon Position and Margin", 'hudson' ),
	esc_html__( "Choose icon position and left(right) margin", 'hudson' )
);
$edgt_separator_with_icon_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$edgt_title_separator_icon_position = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_title_separator_icon_position",
	"",
	esc_html__( "Icon Position", 'hudson' ),
	esc_html__( "Choose a position for an icon", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$row1->addChild(
	"edgt_title_separator_icon_position",
	$edgt_title_separator_icon_position
);

$edgt_title_separator_icon_margins = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_icon_margins",
	"",
	esc_html__( "Margins (px)", 'hudson' ),
	esc_html__( "Enter margin that will refer to left and right margin of the icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_margins",
	$edgt_title_separator_icon_margins
);

$edgt_title_separator_icon_type = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_title_separator_icon_type",
	"",
	esc_html__( "Icon Type", 'hudson' ),
	esc_html__( "Choose icon type", 'hudson' ),
	array(
		"normal" => esc_html__( "Normal", 'hudson' ),
		"circle" => esc_html__( "Circle", 'hudson' ),
		"square" => esc_html__( "Square", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"normal" => "#edgtf_edgt_title_separator_types_container",
			""       => "#edgtf_edgt_title_separator_types_container"
		),
		"show"       => array(
			"circle" => "#edgtf_edgt_title_separator_types_container",
			"square" => "#edgtf_edgt_title_separator_types_container"
		)
	)
);
$edgt_separator_with_icon_container->addChild(
	"edgt_title_separator_icon_type",
	$edgt_title_separator_icon_type
);

$edgt_title_separator_types_container = new HudsonEdgeContainer(
	"edgt_title_separator_types_container",
	"edgt_title_separator_icon_type",
	"",
	array( "", "normal" )
);
$edgt_separator_with_icon_container->addChild(
	"edgt_title_separator_types_container",
	$edgt_title_separator_types_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Define border style for icon", 'hudson' )
);
$edgt_title_separator_types_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_title_separator_icon_border_radius = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_icon_border_radius",
	"",
	esc_html__( "Border Radius (px)", 'hudson' ),
	esc_html__( "Enter border radius for icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_border_radius",
	$edgt_title_separator_icon_border_radius
);

$edgt_title_separator_icon_border_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_icon_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "Enter border width for icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_border_width",
	$edgt_title_separator_icon_border_width
);

$edgt_title_separator_icon_border_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Enter border color for icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_border_color",
	$edgt_title_separator_icon_border_color
);

$edgt_title_separator_icon_border_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_border_hover_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "Enter border color for icon", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_border_hover_color",
	$edgt_title_separator_icon_border_hover_color
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Additional Icon Style", 'hudson' ),
	esc_html__( "Choose adition icon styling", 'hudson' )
);
$edgt_title_separator_types_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$edgt_title_separator_icon_shape_size = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_icon_shape_size",
	"",
	esc_html__( "Shape Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_shape_size",
	$edgt_title_separator_icon_shape_size
);

$edgt_title_separator_icon_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_background_color",
	$edgt_title_separator_icon_background_color
);

$edgt_title_separator_icon_background_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_separator_icon_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_icon_background_hover_color",
	$edgt_title_separator_icon_background_hover_color
);

$edgt_separator_with_custom_icon_container = new HudsonEdgeContainer(
	"edgt_separator_with_custom_icon_container",
	"edgt_title_separator_format",
	"normal",
	array( "normal", "with_icon", "" )
);
$edgt_title_separator_container->addChild(
	"edgt_separator_with_custom_icon_container",
	$edgt_separator_with_custom_icon_container
);

$edgt_separator_custom_icon = new HudsonEdgeMetaField(
	"image",
	"edgt_separator_custom_icon",
	"",
	esc_html__( "Custom Icon", 'hudson' ),
	esc_html__( "Choose custom icon for separator", 'hudson' )
);
$edgt_separator_with_custom_icon_container->addChild(
	"edgt_separator_custom_icon",
	$edgt_separator_custom_icon
);

$edgt_title_separator_type = new HudsonEdgeMetaField(
	"select",
	"edgt_title_separator_type",
	"",
	esc_html__( "Type", 'hudson' ),
	esc_html__( "Choose a Title separator line style", 'hudson' ),
	array(
		""       => "",
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' )
	)
);
$edgt_title_separator_container->addChild(
	"edgt_title_separator_type",
	$edgt_title_separator_type
);

$edgt_title_separator_position = new HudsonEdgeMetaField(
	"select",
	"edgt_title_separator_position",
	"",
	esc_html__( "Position", 'hudson' ),
	esc_html__( "Choose a Title separator position", 'hudson' ),
	array(
		""      => "",
		"above" => esc_html__( "Above Title", 'hudson' ),
		"below" => esc_html__( "Below Title", 'hudson' )
	)
);
$edgt_title_separator_container->addChild(
	"edgt_title_separator_position",
	$edgt_title_separator_position
);

$edgt_title_separator_color = new HudsonEdgeMetaField(
	"color",
	"edgt_title_separator_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for Title separator", 'hudson' )
);
$edgt_title_separator_container->addChild(
	"edgt_title_separator_color",
	$edgt_title_separator_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Size", 'hudson' ),
	esc_html__( 'Define size for Title separator', 'hudson' )
);
$edgt_title_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_title_separator_thickness = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_thickness",
	"",
	esc_html__( "Thickness (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_thickness",
	$edgt_title_separator_thickness
);

$edgt_title_separator_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_width",
	$edgt_title_separator_width
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Margin", 'hudson' ),
	esc_html__( 'Add space at top and bottom of Title separator', 'hudson' )
);
$edgt_title_separator_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$edgt_title_separator_topmargin = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_topmargin",
	"",
	esc_html__( "Top Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_topmargin",
	$edgt_title_separator_topmargin
);

$edgt_title_separator_bottommargin = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_separator_bottommargin",
	"",
	esc_html__( "Bottom Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_title_separator_bottommargin",
	$edgt_title_separator_bottommargin
);

$edgt_title_graphics = new HudsonEdgeMetaField(
	"image",
	"edgt_title-graphics",
	"",
	esc_html__( "Title Graphics", 'hudson' ),
	esc_html__( "Choose a graphic for Title Area, appearing above title", 'hudson' )
);
$edgt_title_standard_container->addChild(
	"edgt_title-graphics",
	$edgt_title_graphics
);

$edgt_enable_breadcrumbs = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_enable_breadcrumbs",
	"",
	esc_html__( "Enable Breadcrumbs", 'hudson' ),
	esc_html__( "Do you want to display breadcrumbs in title area?", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""   => "#edgtf_animation_page_page_title_breadcrumbs_container",
			"no" => "#edgtf_animation_page_page_title_breadcrumbs_container"
		),
		"show"       => array(
			"yes" => "#edgtf_animation_page_page_title_breadcrumbs_container"
		)
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_enable_breadcrumbs",
	$edgt_enable_breadcrumbs
);

$edgt_page_breadcrumbs_color = new HudsonEdgeMetaField(
	"color",
	"edgt_page_breadcrumbs_color",
	"",
	esc_html__( "Breadcrumbs Color", 'hudson' ),
	esc_html__( "Choose a color for breadcrumbs text ", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_page_breadcrumbs_color",
	$edgt_page_breadcrumbs_color
);

$edgt_page_subtitle = new HudsonEdgeMetaField(
	"text",
	"edgt_page_subtitle",
	"",
	esc_html__( "Subtitle Text", 'hudson' ),
	esc_html__( "Enter your subtitle text", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_page_subtitle",
	$edgt_page_subtitle
);

$edgt_page_subtitle_position = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_page_subtitle_position",
	"",
	esc_html__( "Subtitle Position", 'hudson' ),
	esc_html__( "Choose a Subtitle position", 'hudson' ),
	array(
		"below_title" => esc_html__( "Below Title", 'hudson' ),
		"above_title" => esc_html__( "Above Title", 'hudson' )
	)
);
$edgt_page_title_area_container->addChild(
	"edgt_page_subtitle_position",
	$edgt_page_subtitle_position
);

$edgt_page_subtitle_color = new HudsonEdgeMetaField(
	"color",
	"edgt_page_subtitle_color",
	"",
	esc_html__( "Subtitle Text Color", 'hudson' ),
	esc_html__( "Choose a color for subtitle text", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_page_subtitle_color",
	$edgt_page_subtitle_color
);

$edgt_title_content_style = new HudsonEdgeGroup(
	esc_html__( "Title Content Style", 'hudson' ),
	esc_html__( "Define style for title area content", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_title_content_style",
	$edgt_title_content_style
);

$row1 = new HudsonEdgeRow();
$edgt_title_content_style->addChild(
	"row1",
	$row1
);

$edgt_title_area_content_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_area_content_background_color",
	"",
	esc_html__( "Title Area Content Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Title Area Content", 'hudson' )
);
$row1->addChild(
	"edgt_title_area_content_background_color",
	$edgt_title_area_content_background_color
);

$edgt_title_area_content_opacity = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_area_content_opacity",
	"",
	esc_html__( "Title Area Content Background Color Opacity", 'hudson' ),
	esc_html__( "Choose a transparency for the content area background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"edgt_title_area_content_opacity",
	$edgt_title_area_content_opacity
);

$edgt_title_content_in_grid = new HudsonEdgeMetaField(
	"yesno",
	"edgt_title_content_in_grid",
	"",
	esc_html__( "Title Area Content In Grid", 'hudson' ),
	esc_html__( "This option will show title area content in grid", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_title_content_in_grid",
	$edgt_title_content_in_grid
);

$edgt_title_content_shadow = new HudsonEdgeMetaField(
	"yesno",
	"edgt_title_content_shadow",
	"",
	esc_html__( "Show Title Content Area Shadows", 'hudson' ),
	esc_html__( "Enabling this option will show shadows on title content area", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_title_content_shadow",
	$edgt_title_content_shadow
);

$title_area_padding_group = new HudsonEdgeGroup(
	esc_html__( "Title Area Content Padding", 'hudson' ),
	esc_html__( "Define padding for title area content", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"title_area_padding_group",
	$title_area_padding_group
);

$row1 = new HudsonEdgeRow();
$title_area_padding_group->addChild(
	"row1",
	$row1
);

$edgt_title_content_top_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_content_top_padding",
	"",
	esc_html__( "Top Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_content_top_padding",
	$edgt_title_content_top_padding
);

$edgt_title_content_right_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_content_right_padding",
	"",
	esc_html__( "Right Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_content_right_padding",
	$edgt_title_content_right_padding
);

$edgt_title_content_bottom_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_content_bottom_padding",
	"",
	esc_html__( "Bottom Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_content_bottom_padding",
	$edgt_title_content_bottom_padding
);

$edgt_title_content_left_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_content_left_padding",
	"",
	esc_html__( "Left Padding", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_content_left_padding",
	$edgt_title_content_left_padding
);

$edgt_title_style = new HudsonEdgeGroup(
	esc_html__( "Title Style", 'hudson' ),
	esc_html__( "Define style for title", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_title_style",
	$edgt_title_style
);

$row1 = new HudsonEdgeRow();
$edgt_title_style->addChild(
	"row1",
	$row1
);

$edgt_title_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_title_background_color",
	"",
	esc_html__( "Title Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Title", 'hudson' )
);
$row1->addChild(
	"edgt_title_background_color",
	$edgt_title_background_color
);

$edgt_title_opacity = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_opacity",
	"",
	esc_html__( "Title Background Color Opacity", 'hudson' ),
	esc_html__( "Choose a transparency for the title background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"edgt_title_opacity",
	$edgt_title_opacity
);

$title_padding_group = new HudsonEdgeGroup(
	esc_html__( "Title Padding", 'hudson' ),
	esc_html__( "Define padding for title (When using separator around title, only right margin is counted for left/right margin)", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"title_padding_group",
	$title_padding_group
);

$row1 = new HudsonEdgeRow( true );
$title_padding_group->addChild(
	"row1",
	$row1
);

$edgt_title_top_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_top_padding",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_top_padding",
	$edgt_title_top_padding
);

$edgt_title_right_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_right_padding",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_right_padding",
	$edgt_title_right_padding
);

$edgt_title_bottom_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_bottom_padding",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_bottom_padding",
	$edgt_title_bottom_padding
);

$edgt_title_left_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_title_left_padding",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_title_left_padding",
	$edgt_title_left_padding
);

$edgt_subtitle_style = new HudsonEdgeGroup(
	esc_html__( "Subtitle Style", 'hudson' ),
	esc_html__( "Define style for subtitle", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"edgt_subtitle_style",
	$edgt_subtitle_style
);

$row1 = new HudsonEdgeRow();
$edgt_subtitle_style->addChild(
	"row1",
	$row1
);

$edgt_subtitle_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_subtitle_background_color",
	"",
	esc_html__( "Subtitle Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Subtitle", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_background_color",
	$edgt_subtitle_background_color
);

$edgt_subtitle_opacity = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_opacity",
	"",
	esc_html__( "Subtitle Background Color Opacity", 'hudson' ),
	esc_html__( "Choose a transparency for the subtitle background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_opacity",
	$edgt_subtitle_opacity
);

$subtitle_padding_group = new HudsonEdgeGroup(
	esc_html__( "Subtitle Padding", 'hudson' ),
	esc_html__( "Define padding for subtitle (When using separator around subtitle, only right margin is counted for left/right margin)", 'hudson' )
);
$edgt_page_title_area_container->addChild(
	"subtitle_padding_group",
	$subtitle_padding_group
);
$row1 = new HudsonEdgeRow( true );
$subtitle_padding_group->addChild(
	"row1",
	$row1
);

$edgt_subtitle_top_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_top_padding",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_top_padding",
	$edgt_subtitle_top_padding
);

$edgt_subtitle_right_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_right_padding",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_right_padding",
	$edgt_subtitle_right_padding
);

$edgt_subtitle_bottom_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_bottom_padding",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_bottom_padding",
	$edgt_subtitle_bottom_padding
);

$edgt_subtitle_left_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_subtitle_left_padding",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description.", 'hudson' )
);
$row1->addChild(
	"edgt_subtitle_left_padding",
	$edgt_subtitle_left_padding
);

//Page Title Animations
$edgtTitleAnimations = new HudsonEdgeMetaBox(
	'page',
	esc_html__( 'Title Animations', 'hudson' ),
	'edgt_show-page-title',
	array( 'no' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	'page_title_animations',
	$edgtTitleAnimations
);

//Whole title content animation
$page_page_title_whole_content_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_title_whole_content_animations',
	'',
	esc_html__( 'Enable Whole Title Content Animation', 'hudson' ),
	esc_html__( 'This option will enable whole title content animation', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_title_whole_content_animations_container',
			'no' => '#edgtf_page_page_title_whole_content_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_title_whole_content_animations_container'
		)
	)
);
$edgtTitleAnimations->addChild(
	'page_page_title_whole_content_animations',
	$page_page_title_whole_content_animations
);

$page_page_title_whole_content_animations_container = new HudsonEdgeContainer(
	'page_page_title_whole_content_animations_container',
	'page_page_title_whole_content_animations',
	'',
	array( '', 'no' )
);
$edgtTitleAnimations->addChild(
	'page_page_title_whole_content_animations_container',
	$page_page_title_whole_content_animations_container
);

$page_page_title_whole_content_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_title_whole_content_animations_container->addChild(
	'page_page_title_whole_content_animations_data_start',
	$page_page_title_whole_content_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_title_whole_content_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_title_whole_content_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_whole_content_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_title_whole_content_data_start',
	$page_page_title_whole_content_data_start
);

$page_page_title_whole_content_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_whole_content_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_title_whole_content_start_custom_style',
	$page_page_title_whole_content_start_custom_style
);

$page_page_title_whole_content_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_title_whole_content_animations_container->addChild(
	'page_page_title_whole_content_animations_data_end',
	$page_page_title_whole_content_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_title_whole_content_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_title_whole_content_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_whole_content_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_title_whole_content_data_end',
	$page_page_title_whole_content_data_end
);

$page_page_title_whole_content_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_whole_content_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_title_whole_content_end_custom_style',
	$page_page_title_whole_content_end_custom_style
);

//Title Animations
$animation_page_page_title_container = new HudsonEdgeContainerNoStyle(
	'animation_page_page_title_container',
	'edgt_show_page_title_text',
	'no'
);
$edgtTitleAnimations->addChild(
	'animation_page_page_title_container',
	$animation_page_page_title_container
);

$page_page_title_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_title_animations',
	'',
	esc_html__( 'Enable Page Title Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Scroll Animations', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_title_animations_container',
			'no' => '#edgtf_page_page_title_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_title_animations_container'
		)
	)
);

$animation_page_page_title_container->addChild(
	'page_page_title_animations',
	$page_page_title_animations
);

$page_page_title_animations_container = new HudsonEdgeContainer(
	'page_page_title_animations_container',
	'page_page_title_animations',
	'',
	array( '', 'no' )
);
$animation_page_page_title_container->addChild(
	'page_page_title_animations_container',
	$page_page_title_animations_container
);

$page_page_title_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_title_animations_container->addChild(
	'page_page_title_animations_data_start',
	$page_page_title_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_title_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_title_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_title_data_start',
	$page_page_title_data_start
);

$page_page_title_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_title_start_custom_style',
	$page_page_title_start_custom_style
);

$page_page_title_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_title_animations_container->addChild(
	'page_page_title_animations_data_end',
	$page_page_title_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_title_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_title_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_title_data_end',
	$page_page_title_data_end
);

$page_page_title_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_title_end_custom_style',
	$page_page_title_end_custom_style
);

//Title Separator Animations
$page_page_title_separator_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_title_separator_animations',
	'',
	esc_html__( 'Enable Page Separator Title Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Separator Scroll Animations', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_title_separator_animations_container',
			'no' => '#edgtf_page_page_title_separator_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_title_separator_animations_container'
		)
	)
);
$edgtTitleAnimations->addChild(
	'page_page_title_separator_animations',
	$page_page_title_separator_animations
);

$page_page_title_separator_animations_container = new HudsonEdgeContainer(
	'page_page_title_separator_animations_container',
	'page_page_title_separator_animations',
	'',
	array( 'no', '' )
);
$edgtTitleAnimations->addChild(
	'page_page_title_separator_animations_container',
	$page_page_title_separator_animations_container
);

$page_page_title_separator_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_title_separator_animations_container->addChild(
	'page_page_title_separator_animations_data_start',
	$page_page_title_separator_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_title_separator_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_title_separator_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_separator_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_title_separator_data_start',
	$page_page_title_separator_data_start
);

$page_page_title_separator_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_separator_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_title_separator_start_custom_style',
	$page_page_title_separator_start_custom_style
);

$page_page_title_separator_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_title_separator_animations_container->addChild(
	'page_page_title_separator_animations_data_end',
	$page_page_title_separator_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_title_separator_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_title_separator_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_separator_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_title_separator_data_end',
	$page_page_title_separator_data_end
);

$page_page_title_separator_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_separator_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_title_separator_end_custom_style',
	$page_page_title_separator_end_custom_style
);

//Subtitle Animations
$page_page_subtitle_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_subtitle_animations',
	'',
	esc_html__( 'Enable Page Subtitle Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Subtitle Scroll Animations', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_subtitle_animations_container',
			'no' => '#edgtf_page_page_subtitle_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_subtitle_animations_container'
		)
	)
);
$edgtTitleAnimations->addChild(
	'page_page_subtitle_animations',
	$page_page_subtitle_animations
);

$page_page_subtitle_animations_container = new HudsonEdgeContainer(
	'page_page_subtitle_animations_container',
	'page_page_subtitle_animations',
	'',
	array( '', 'no' )
);
$edgtTitleAnimations->addChild(
	'page_page_subtitle_animations_container',
	$page_page_subtitle_animations_container
);

$page_page_subtitle_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_subtitle_animations_container->addChild(
	'page_page_subtitle_animations_data_start',
	$page_page_subtitle_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_subtitle_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_subtitle_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_subtitle_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_subtitle_data_start',
	$page_page_subtitle_data_start
);

$page_page_subtitle_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_subtitle_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_subtitle_start_custom_style',
	$page_page_subtitle_start_custom_style
);

$page_page_subtitle_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_subtitle_animations_container->addChild(
	'page_page_subtitle_animations_data_end',
	$page_page_subtitle_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_subtitle_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_subtitle_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_subtitle_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_subtitle_data_end',
	$page_page_subtitle_data_end
);

$page_page_subtitle_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_subtitle_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_subtitle_end_custom_style',
	$page_page_subtitle_end_custom_style
);

//Graphic Animations
$page_page_title_graphic_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_title_graphic_animations',
	'',
	esc_html__( 'Enable Page Title Graphic Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Graphic Scroll Animations', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_title_graphic_animations_container',
			'no' => '#edgtf_page_page_title_graphic_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_title_graphic_animations_container'
		)
	)
);
$edgtTitleAnimations->addChild(
	'page_page_title_graphic_animations',
	$page_page_title_graphic_animations
);

$page_page_title_graphic_animations_container = new HudsonEdgeContainer(
	'page_page_title_graphic_animations_container',
	'page_page_title_graphic_animations',
	'',
	array( '', 'no' )
);
$edgtTitleAnimations->addChild(
	'page_page_title_graphic_animations_container',
	$page_page_title_graphic_animations_container
);

$page_page_title_graphic_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_title_graphic_animations_container->addChild(
	'page_page_title_graphic_animations_data_start',
	$page_page_title_graphic_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_title_graphic_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_title_graphic_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_graphic_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_title_graphic_data_start',
	$page_page_title_graphic_data_start
);

$page_page_title_graphic_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_graphic_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_title_graphic_start_custom_style',
	$page_page_title_graphic_start_custom_style
);

$page_page_title_graphic_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_title_graphic_animations_container->addChild(
	'page_page_title_graphic_animations_data_end',
	$page_page_title_graphic_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_title_graphic_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_title_graphic_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_graphic_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_title_graphic_data_end',
	$page_page_title_graphic_data_end
);

$page_page_title_graphic_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_graphic_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_title_graphic_end_custom_style',
	$page_page_title_graphic_end_custom_style
);

//Breadcrumb animations
$animation_page_page_title_breadcrumbs_container = new HudsonEdgeContainerNoStyle(
	'animation_page_page_title_breadcrumbs_container',
	'edgt_enable_breadcrumbs',
	'no'
);
$edgtTitleAnimations->addChild(
	'animation_page_page_title_breadcrumbs_container',
	$animation_page_page_title_breadcrumbs_container
);

$page_page_title_breadcrumbs_animations = new HudsonEdgeMetaField(
	'selectblank',
	'page_page_title_breadcrumbs_animations',
	'',
	esc_html__( 'Enable Page Title Breadcrumbs Animations', 'hudson' ),
	esc_html__( 'This option will enable Page Title Breadcrumbs Scroll Animations', 'hudson' ),
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			''   => '#edgtf_page_page_title_breadcrumbs_animations_container',
			'no' => '#edgtf_page_page_title_breadcrumbs_animations_container'
		),
		'show'       => array(
			'yes' => '#edgtf_page_page_title_breadcrumbs_animations_container'
		)
	)
);
$animation_page_page_title_breadcrumbs_container->addChild(
	'page_page_title_breadcrumbs_animations',
	$page_page_title_breadcrumbs_animations
);

$page_page_title_breadcrumbs_animations_container = new HudsonEdgeContainer(
	'page_page_title_breadcrumbs_animations_container',
	'page_page_title_breadcrumbs_animations',
	'',
	array( '', 'no' )
);
$animation_page_page_title_breadcrumbs_container->addChild(
	'page_page_title_breadcrumbs_animations_container',
	$page_page_title_breadcrumbs_animations_container
);

$page_page_title_breadcrumbs_animations_data_start = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation Start Point', 'hudson' ),
	esc_html__( 'These are properties for the first keyframe in scrolling animation', 'hudson' )
);
$page_page_title_breadcrumbs_animations_container->addChild(
	'page_page_title_breadcrumbs_animations_data_start',
	$page_page_title_breadcrumbs_animations_data_start
);

$row1 = new HudsonEdgeRow();
$page_page_title_breadcrumbs_animations_data_start->addChild(
	'row1',
	$row1
);

$page_page_title_breadcrumbs_data_start = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_breadcrumbs_data_start',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row1->addChild(
	'page_page_title_breadcrumbs_data_start',
	$page_page_title_breadcrumbs_data_start
);

$page_page_title_breadcrumbs_start_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_breadcrumbs_start_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row1->addChild(
	'page_page_title_breadcrumbs_start_custom_style',
	$page_page_title_breadcrumbs_start_custom_style
);

$page_page_title_breadcrumbs_animations_data_end = new HudsonEdgeGroup(
	esc_html__( 'Scrolling Animation End Point', 'hudson' ),
	esc_html__( 'These are properties for the last keyframe in scrolling animation', 'hudson' )
);
$page_page_title_breadcrumbs_animations_container->addChild(
	'page_page_title_breadcrumbs_animations_data_end',
	$page_page_title_breadcrumbs_animations_data_end
);

$row2 = new HudsonEdgeRow();
$page_page_title_breadcrumbs_animations_data_end->addChild(
	'row2',
	$row2
);

$page_page_title_breadcrumbs_data_end = new HudsonEdgeMetaField(
	'textsimple',
	'page_page_title_breadcrumbs_data_end',
	'',
	esc_html__( 'Scrollbar Top Distance (px)', 'hudson' )
);
$row2->addChild(
	'page_page_title_breadcrumbs_data_end',
	$page_page_title_breadcrumbs_data_end
);

$page_page_title_breadcrumbs_end_custom_style = new HudsonEdgeMetaField(
	'textareasimple',
	'page_page_title_breadcrumbs_end_custom_style',
	'',
	esc_html__( 'Enter CSS declarations separated by semicolons', 'hudson' )
);
$row2->addChild(
	'page_page_title_breadcrumbs_end_custom_style',
	$page_page_title_breadcrumbs_end_custom_style
);

// Content Bottom

$edgtContentBottom = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Content Bottom", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_content_bottom",
	$edgtContentBottom
);

$edgt_enable_content_bottom_area = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_enable_content_bottom_area",
	"",
	esc_html__( "Show Content Bottom Area", 'hudson' ),
	esc_html__( "Do you want to show content bottom area?", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"no" => "#edgtf_edgt_enable_content_bottom_area_container",
			""   => "#edgtf_edgt_enable_content_bottom_area_container"
		),
		"show"       => array(
			"yes" => "#edgtf_edgt_enable_content_bottom_area_container"
		)
	)
);
$edgtContentBottom->addChild(
	"edgt_enable_content_bottom_area",
	$edgt_enable_content_bottom_area
);

$edgt_enable_content_bottom_area_container = new HudsonEdgeContainer(
	"edgt_enable_content_bottom_area_container",
	"edgt_enable_content_bottom_area",
	"no",
	array( "", "no" )
);
$edgtContentBottom->addChild(
	"edgt_enable_content_bottom_area_container",
	$edgt_enable_content_bottom_area_container
);

$edgt_content_bottom_background_color = new HudsonEdgeMetaField(
	"color",
	"edgt_content_bottom_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a color for content bottom area", 'hudson' )
);
$edgt_enable_content_bottom_area_container->addChild(
	"edgt_content_bottom_background_color",
	$edgt_content_bottom_background_color
);

$edgt_choose_content_bottom_sidebar = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_choose_content_bottom_sidebar",
	"",
	esc_html__( "Custom Widget", 'hudson' ),
	esc_html__( "Choose Custom Widget area to display", 'hudson' ),
	$edgt_custom_sidebars
);
$edgt_enable_content_bottom_area_container->addChild(
	"edgt_choose_content_bottom_sidebar",
	$edgt_choose_content_bottom_sidebar
);

$edgt_content_bottom_sidebar_in_grid = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_content_bottom_sidebar_in_grid",
	"",
	esc_html__( "Display in Grid", 'hudson' ),
	esc_html__( "Enabling this option will place Content Bottom in grid", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgt_enable_content_bottom_area_container->addChild(
	"edgt_content_bottom_sidebar_in_grid",
	$edgt_content_bottom_sidebar_in_grid
);

// Blog

$edgtBlog = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Blog", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_blog",
	$edgtBlog
);

$edgt_choose_blog_category = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_choose-blog-category",
	"",
	esc_html__( "Blog Category", 'hudson' ),
	esc_html__( "Choose category of posts to display (leave empty to display all categories)", 'hudson' ),
	$edgt_blog_categories
);
$edgtBlog->addChild(
	"edgt_choose-blog-category",
	$edgt_choose_blog_category
);

$edgt_show_posts_per_page = new HudsonEdgeMetaField(
	"text",
	"edgt_show-posts-per-page",
	"",
	esc_html__( "Number of Posts", 'hudson' ),
	esc_html__( "Enter the number of posts to display", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtBlog->addChild(
	"edgt_show-posts-per-page",
	$edgt_show_posts_per_page
);

// Side Bar Area

$edgtSideBar = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Sidebar", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_side_bar",
	$edgtSideBar
);

$edgt_show_sidebar = new HudsonEdgeMetaField(
	"select",
	"edgt_show-sidebar",
	"default",
	esc_html__( "Layout", 'hudson' ),
	esc_html__( "Choose the sidebar layout", 'hudson' ),
	array(
		"default" => esc_html__( "Default", 'hudson' ),
		"1" => esc_html__( "Sidebar 1/3 right", 'hudson' ),
		"2" => esc_html__( "Sidebar 1/4 right", 'hudson' ),
		"3" => esc_html__( "Sidebar 1/3 left", 'hudson' ),
		"4" => esc_html__( "Sidebar 1/4 left", 'hudson' ),
	)
);
$edgtSideBar->addChild(
	"edgt_show-sidebar",
	$edgt_show_sidebar
);

$edgt_choose_sidebar = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_choose-sidebar",
	"default",
	esc_html__( "Choose Widget Area in Sidebar", 'hudson' ),
	esc_html__( "Choose Custom Widget area to display in Sidebar", 'hudson' ),
	$edgt_custom_sidebars
);
$edgtSideBar->addChild(
	"edgt_choose-sidebar",
	$edgt_choose_sidebar
);

// Footer

$edgtFooter = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Footer", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_footer",
	$edgtFooter
);

$edgt_footer_disable = new HudsonEdgeMetaField(
	"yesno",
	"edgt_footer-disable",
	"no",
	esc_html__( "Disable Footer for this Page", 'hudson' ),
	esc_html__( "Enabling this option will hide footer on your page", 'hudson' )
);
$edgtFooter->addChild(
	"edgt_footer-disable",
	$edgt_footer_disable
);

// Full Screen Template

$edgtFullScreenTemplate = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "Full Screen Template", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_full_screen_template",
	$edgtFullScreenTemplate
);

$edgt_full_screen_sections_on_small_screens = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_full_screen_sections_on_small_screens",
	"",
	esc_html__( "Enable Full Screen Sections on Small Screens", 'hudson' ),
	esc_html__( "Enabling this option will turn on Full Screen Sections on small screens", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	)
);
$edgtFullScreenTemplate->addChild(
	"edgt_full_screen_sections_on_small_screens",
	$edgt_full_screen_sections_on_small_screens
);

// SEO

$edgtSeo = new HudsonEdgeMetaBox(
	"page",
	esc_html__( "SEO", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"page_seo",
	$edgtSeo
);

$seo_title = new HudsonEdgeMetaField(
	"text",
	"edgt_seo_title",
	"",
	esc_html__( "SEO Title", 'hudson' ),
	esc_html__( "Enter custom Title for this page", 'hudson' )
);
$edgtSeo->addChild(
	"edgt_seo_title",
	$seo_title
);

$seo_keywords = new HudsonEdgeMetaField(
	"text",
	"edgt_seo_keywords",
	"",
	esc_html__( "SEO Keywords", 'hudson' ),
	esc_html__( "Enter the list of keywords separated by commas", 'hudson' )
);
$edgtSeo->addChild(
	"edgt_seo_keywords",
	$seo_keywords
);

$seo_description = new HudsonEdgeMetaField(
	"textarea",
	"edgt_seo_description",
	"",
	esc_html__( "SEO Description", 'hudson' ),
	esc_html__( "Enter meta description for this page", 'hudson' )
);
$edgtSeo->addChild(
	"edgt_seo_description",
	$seo_description
);